/**
 * Fecha de creacin: (23/08/2010)
 */   
package com.ejie.p06b.pdf.xml;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BResources;


/**
 * Clase que representa el xml para el pdf de Test
 */
public class P06BPdtesEnvioDECXML{
   
	public static String getXml(ArrayList listTest, HttpServletRequest request)
	throws Exception {
		P06BLog.send(2,"P06BPdtesEnvioDECXML", "getXml(...)");
		
		String ejerDEC = (request.getParameter("EjercicioPdtesDEC")==null)?"":request.getParameter("EjercicioPdtesDEC");
		
		HashMap datosMap = getDatos(listTest);
		ArrayList listRegistros = (ArrayList)datosMap.get("listTest");
		String xml="";
		xml+="<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
		xml+=	"<listado>";
		xml+=		"<fechaObtencion>";
		xml+=			datosMap.get("fechaObtencion");
		xml+=		"</fechaObtencion>";
		xml+=		"<ejerDEC>";
		xml+=			ejerDEC;//datosMap.get("ejerDEC");
		xml+=		"</ejerDEC>";
		
		for(int i=0;i<listTest.size();i++){
			P06B20T00Datatype registro = (P06B20T00Datatype)listRegistros.get(i);
			xml+=		"<registro>";
			
			//Expediente
			xml+=			"<campoExpediente>";			
			xml+=				(registro.getExpedi()==null)?"":registro.getExpedi();
			xml+=			"</campoExpediente>";
			
			//Codigo MS
			xml+=			"<campoFhAlta>";			
			xml+=				(registro.getFechaAl()==null)?"":registro.getFechaAl();
			xml+=			"</campoFhAlta>";
			
			//Nif Cif
			xml+=			"<campoNifCif>";
			xml+=				(registro.getDni()==null)?"":registro.getDni();
			xml+=			"</campoNifCif>";
			
			//Mediador
			xml+=			"<campoMediador>";
			if( (P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA.equals(registro.getClase()))
				|| (P06BConstantes.P06B_AGENTEVINCULADO_FISICA.equals(registro.getClase())) 
				|| (P06BConstantes.P06B_REASEGUROS_FISICA.equals(registro.getClase())) ){
				xml += (((registro.getNombre()==null)?"":registro.getNombre()) +" "+ ((registro.getApe1()==null)?"":registro.getApe1()) +" "+ ((registro.getApe2()==null)?"":registro.getApe2()));
			}else{
				xml += ((registro.getRazsoc()==null)?"":registro.getRazsoc());
			}
			xml+=			"</campoMediador>";
			
			//Estado
			xml+=			"<campoEstado>";
			if (P06BConstantes.P06B_CORREDORES_ESTADO_ALTA.equals(registro.getEstado())){
				xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.alta"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_BAJA.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.baja"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_SUSPENSION.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.suspension"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_REVISION.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.revision"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_ALTA.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.pdteAlta"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_ALTA_RECHAZADA.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.altaRechazada"));
		  	}
			xml+=			"</campoEstado>";
			
			xml+=		"</registro>";
		}
		xml+=	"</listado>";
		
		//En la razon social de algunos mediadores est el smbolo &. Da el error:
		//"The entity name must immediately follow the '&' in the entity reference."
		//Sustituyendo el smbolo & por su codificacin, desaparece el error.
		xml = xml.replaceAll("&","&amp;");
		return xml;
	}
	
	//Devolver un hashMap de elementos donde la clave = etiqueta en el xml
	private static HashMap getDatos(ArrayList listTest)
	throws Exception {
		P06BLog.send(2,"P06BPdtesEnvioDECXML", "getDatos(...)");
		//String ejerAnterior = "";
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy"); 
		String fechaObtencion=sdf.format(new java.util.Date());
		
		//SimpleDateFormat formatoAnyo = new SimpleDateFormat("yyyy");
		//ejerAnterior = String.valueOf(Integer.parseInt(formatoAnyo.format(new java.util.Date())) - 1);	
		
		HashMap datosMap = new HashMap();
		datosMap.put("fechaObtencion",fechaObtencion);
		//datosMap.put("ejerDEC",ejerAnterior);
		datosMap.put("listTest",listTest);
		return datosMap;
	}
}